/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
 */
#ifndef PCA_HELPER_H
#define PCA_HELPER_H

#include <memory>
#include <algorithm>
#include <cstdint>
#include <vector>
#include <string>

#define SCANN_API_PUBLIC __attribute__((visibility("default")))


namespace research_scann {


class SCANN_API_PUBLIC KReorderHelperClass {
public:
    enum class PMODE {INIT, READY, DISABLE};
    enum class K_DIS_MEASURE {UNDEFINED, DOT_PRODUCT, SQUARED_L2};
    virtual PMODE GetMode() = 0;
    virtual bool Build(int dimensionality_, K_DIS_MEASURE distance_type) = 0;
    virtual bool TransformBase(const float* data, const int n_points) = 0;
    virtual bool ReorderOneToMany(const float* qptr, std::vector<std::pair<uint32_t, float>>* result) = 0;
};

SCANN_API_PUBLIC extern std::unique_ptr<KReorderHelperClass> kReorderHelper;
SCANN_API_PUBLIC std::unique_ptr<KReorderHelperClass> KReorderHelperFactory();

}


#endif